/*
 * @ some common function	
 * @author sunnyjiang
 * @version 1.2
 * @date 2011-03-30
 */

var utils = {};
/*
   debug section
 */

utils.log = function(msg){
	try{
		qqbrowser.log.info(msg);
	}catch(err){
		console.info("utils_log: "+msg);
	}
};
/*
   qqbrowser api utils
 */
// get qqbrowser api return string , return a object 
utils.unpack = function(jsonstr){
	var ret={};
	try{
		var tmp = JSON.parse(jsonstr);
		ret = tmp[0];
	}catch(err){
		utils.log("unpack err :[ "+err.message+" ]: "+jsonstr);
	}
	return ret;
};

// clone
utils.clone = function(obj){
	var ret={};
	if ('object' == typeof(obj) && 'undifined'!=typeof(obj.length)){
		ret = obj.slice();
	}else{
		for(var key in obj){
			if ('object' == typeof(obj[key]) ){
				ret[key] = utils.clone(obj[key]);
			}else{
				ret[key] = obj[key];
			}
		}
	}
	return ret;
};

/**
 * 通过正则表达式判断给定的字符串是否是有效的 URL 地址，
 * 严格的标准请参照 RFC 3986
 */
utils.isValidUrl = function(str) {
    var pattern = '^(http(s)?://)?'
                + '(([0-9a-z_!~*\'().&=+$%-]+:)?[0-9a-z_!~*\'().&=+$%-]+@)?' // username:password@
				+ '(localhost(:[0-9]{1,4})?)'
				+ '|'   //localhost bug
                + '(([0-9]{1,3}\\.){3}[0-9]{1,3}' // IP 形式的 URL - 199.194.52.184
                + '|' // 允许 IP 和 DOMAIN（域名）
                + '([0-9a-z_!~*\'()-]+\\.)*' // 域名 - www.
                + '([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.' // 二级域名
                + '[a-z]{2,6})' // first level domain - .com or .museum
                + '(:[0-9]{1,4})?' // 端口 - :80
                + '((/?)|' // a slash isn't required if there is no file name
                + '(/[0-9a-z_!~*\'().;?:@&=+$,%#-]+)+/?)$';
    var re = new RegExp(pattern, 'i');
    if (re.test(str)) {
        return true;
    } else {
        return false;
    }
};

utils.json_parse_filter = function(key, value) {
    if (typeof(value) == 'string') {
        return unescape(value);
    } else {
        return value;
    }
};
utils.json_parse_func = function (key, value) {
    if (typeof(value) == 'string')
        return unescape(value);
    else
        return value;
};
